/*
 *	LCD interface example
 *	This code will interface to a standard LCD controller
 *	like the Hitachi HD44780. It uses it in 4 bit mode, with
 *	the hardware connected as follows (the standard 14 pin 
 *	LCD connector is used):
 *	
 *	PORTB bits 5 to 7 are connected to the LCD data bits 4-7 (high nibble)
 *	PORTB bit 2 is connected to the LCD RS input (register select)
 *	PORTB bit 1 is connected to the LCD EN bit (enable)
 *	
 *	To use these routines, set up the port I/O (TRISA, TRISB) then
 *	call lcd_init(), then other routines as required.

	Correspond Hitech PIC C pro9.60pl4 build 3206 or higher
	by air variable Nov.30/2008
*/

//__delay_xx frequency set
#define MHz 000000
#define _XTAL_FREQ 8MHz

#include <htc.h>
#include	"lcd.h"

#define LCD_RS RB2
#define LCD_EN RB1

#define	LCD_STROBE	((LCD_EN = 1),(LCD_EN=0))	// spec. min 500ns ***fix 2009/11/17 air variable 

/* write a byte to the LCD in 4 bit mode */

void lcd_data_byteset(unsigned char c){
	PORTB = (PORTB & 0x0F) |  c ;		//Only high 4bit DATA
	LCD_STROBE;
}

void lcd_data_set(unsigned char c){
	PORTB = (PORTB & 0x0F) | (c & 0xF0)  ;			//Hi SIDE DATA
	LCD_STROBE;
	PORTB = (PORTB & 0x0F) |  ((c <<4)  & 0xF0 );		//low SIDE DATA
	LCD_STROBE;
}

void
lcd_write(unsigned char c)
{
	LCD_RS = 0;
	lcd_data_set(c);
	__delay_us(40);	//PICC Pro
}

/*
 * 	Clear and home the LCD
 */

void
lcd_clear(void)
{
	LCD_RS = 0;
	lcd_write(0x1);
	__delay_ms(2); //PICC Pro
}

/* write a string of chars to the LCD */

void
lcd_puts(const char * s)
{
	LCD_RS = 1;	// write characters
	while(*s)
		lcd_putch(*s++);
}

/* write one character to the LCD lcd_putsɕKv*/

void
lcd_putch(char c)
{
	LCD_RS = 1;	// write characters
	lcd_data_set(c);
	__delay_us(40);//PICC Pro
}
/*
 * Go to the specified position
 */

void
lcd_goto(unsigned char pos)
{
	LCD_RS = 0;
	lcd_write(0x80+pos);
}
	
/* initialise the LCD - put into 4 bit mode */

void
lcd_init(void)
{
	__delay_ms(200);		//lcdグ҂@K{?
	LCD_RS = 0;	// write control bytes
	__delay_ms(15);	// power on delay (PICC Pro)
	//lcd_data_byteset( 0x03 );	// attention!
	lcd_data_byteset( 0x30 );	//8bit[h00111
	__delay_ms(5);	//PICC Pro
	LCD_STROBE;		//8bit[h0011ւQ
	//__delay_us(100);//PICC Pro
	__delay_ms(5);
	LCD_STROBE;		//8bit[h0011ւR
	__delay_ms(5);	//PICC Pro
	lcd_data_byteset( 0x20 ) ;	// 4bit[h
	__delay_us(100);	//PICC Pro

	//ȍ~SŎs
	lcd_write(0x28);	// 4 bit mode, 1/16 duty, 5x8 font
	lcd_write(0x08);	// display off
	lcd_write(0x0F);	// display on, blink curson on
	lcd_write(0x06);	// entry mode
}

/**printfɕKv**/
void
putch(char c)
{
	LCD_RS = 1;	// write characters
	lcd_data_set(c);
	__delay_us(40);	//PICC Pro
}